@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.zone.title_singular') }}:
                    {{ trans('cruds.zone.fields.id') }}
                    {{ $zone->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.zone.fields.id') }}
                            </th>
                            <td>
                                {{ $zone->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.zone.fields.name') }}
                            </th>
                            <td>
                                {{ $zone->name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.zone.fields.is_active') }}
                            </th>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled {{ $zone->is_active ? 'checked' : '' }}>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.zone.fields.state') }}
                            </th>
                            <td>
                                @if($zone->state)
                                    <span class="badge badge-relationship">{{ $zone->state->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('zone_edit')
                    <a href="{{ route('admin.zones.edit', $zone) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.zones.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
