@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.visitRoute.title_singular') }}:
                    {{ trans('cruds.visitRoute.fields.id') }}
                    {{ $visitRoute->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.visitRoute.fields.id') }}
                            </th>
                            <td>
                                {{ $visitRoute->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.visitRoute.fields.from') }}
                            </th>
                            <td>
                                {{ $visitRoute->from }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.visitRoute.fields.to') }}
                            </th>
                            <td>
                                {{ $visitRoute->to }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.visitRoute.fields.journey_distance') }}
                            </th>
                            <td>
                                {{ $visitRoute->journey_distance }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.visitRoute.fields.journey_fare') }}
                            </th>
                            <td>
                                {{ $visitRoute->journey_fare }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.visitRoute.fields.vehicle_type') }}
                            </th>
                            <td>
                                {{ $visitRoute->vehicle_type_label }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.visitRoute.fields.journey_type') }}
                            </th>
                            <td>
                                {{ $visitRoute->journey_type_label }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.visitRoute.fields.note') }}
                            </th>
                            <td>
                                {{ $visitRoute->note }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.visitRoute.fields.route_cost') }}
                            </th>
                            <td>
                                {{ $visitRoute->route_cost }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.visitRoute.fields.user') }}
                            </th>
                            <td>
                                @if($visitRoute->user)
                                    <span class="badge badge-relationship">{{ $visitRoute->user->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.visitRoute.fields.reimbursement') }}
                            </th>
                            <td>
                                @if($visitRoute->reimbursement)
                                    <span class="badge badge-relationship">{{ $visitRoute->reimbursement->amount ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('visit_route_edit')
                    <a href="{{ route('admin.visit-routes.edit', $visitRoute) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.visit-routes.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection