@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.region.title_singular') }}:
                    {{ trans('cruds.region.fields.id') }}
                    {{ $region->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.region.fields.id') }}
                            </th>
                            <td>
                                {{ $region->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.region.fields.name') }}
                            </th>
                            <td>
                                {{ $region->name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.region.fields.is_active') }}
                            </th>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled {{ $region->is_active ? 'checked' : '' }}>
                            </td>
                        </tr>
                        {{-- <tr>
                            <th>
                                {{ trans('cruds.region.fields.circle') }}
                            </th>
                            <td>
                                @if($region->circle)
                                    <span class="badge badge-relationship">{{ $region->circle->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.region.fields.engineer') }}
                            </th>
                            <td>
                                @foreach($region->engineer as $key => $entry)
                                    <span class="badge badge-relationship">{{ $entry->name }}</span>
                                @endforeach
                            </td>
                        </tr> --}}
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('region_edit')
                    <a href="{{ route('admin.regions.edit', $region) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.regions.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
