@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.purchase.title_singular') }}:
                    {{ trans('cruds.purchase.fields.id') }}
                    {{ $purchase->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.purchase.fields.id') }}
                            </th>
                            <td>
                                {{ $purchase->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.purchase.fields.suply_invc_no') }}
                            </th>
                            <td>
                                {{ $purchase->suply_invc_no }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.purchase.fields.prchs_date') }}
                            </th>
                            <td>
                                {{ $purchase->prchs_date }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.purchase.fields.party_ac') }}
                            </th>
                            <td>
                                {{ $purchase->party_ac_label }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.purchase.fields.total_invoic') }}
                            </th>
                            <td>
                                {{ $purchase->total_invoic }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.purchase.fields.csgt_amt') }}
                            </th>
                            <td>
                                {{ $purchase->csgt_amt }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.purchase.fields.sgst_amt') }}
                            </th>
                            <td>
                                {{ $purchase->sgst_amt }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.purchase.fields.igst_amt') }}
                            </th>
                            <td>
                                {{ $purchase->igst_amt }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.purchase.fields.invoice_total_wo_tax') }}
                            </th>
                            <td>
                                {{ $purchase->invoice_total_wo_tax }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.purchase.fields.details') }}
                            </th>
                            <td>
                                {{ $purchase->details }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('purchase_edit')
                    <a href="{{ route('admin.purchases.edit', $purchase) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.purchases.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection