@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.monthlyPayslip.title_singular') }}:
                    {{ trans('cruds.monthlyPayslip.fields.id') }}
                    {{ $monthlyPayslip->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.id') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.fin_yr') }}
                            </th>
                            <td>
                                @if($monthlyPayslip->finYr)
                                    <span class="badge badge-relationship">{{ $monthlyPayslip->finYr->title ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.year') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->year_label }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.month') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->month_label }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.user') }}
                            </th>
                            <td>
                                @if($monthlyPayslip->user)
                                    <span class="badge badge-relationship">{{ $monthlyPayslip->user->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.emp_code') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->emp_code }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.location') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->location }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.name') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.payment_mode') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->payment_mode }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.bank') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->bank }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.bank_ac_no') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->bank_ac_no }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.aadhaar') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->aadhaar }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.blood_group') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->blood_group }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.days_in_month') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->days_in_month }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.lwp_days') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->lwp_days }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.working_days') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->working_days }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.esic_no') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->esic_no }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.uan') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->uan }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.basic_salary') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->basic_salary }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.hra') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->hra }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.ta') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->ta }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.incentive') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->incentive }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.total_earning') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->total_earning }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.pf') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->pf }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.ptax') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->ptax }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.esic') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->esic }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.total_deduction') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->total_deduction }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.total_payment') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->total_payment }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.monthlyPayslip.fields.payment_status') }}
                            </th>
                            <td>
                                {{ $monthlyPayslip->payment_status_label }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('monthly_payslip_edit')
                    <a href="{{ route('admin.monthly-payslips.edit', $monthlyPayslip) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.monthly-payslips.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection