@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.lgAttribute.title_singular') }}:
                    {{ trans('cruds.lgAttribute.fields.id') }}
                    {{ $lgAttribute->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.lgAttribute.fields.id') }}
                            </th>
                            <td>
                                {{ $lgAttribute->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.lgAttribute.fields.title') }}
                            </th>
                            <td>
                                {{ $lgAttribute->title }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.lgAttribute.fields.description') }}
                            </th>
                            <td>
                                {{ $lgAttribute->description }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.lgAttribute.fields.is_active') }}
                            </th>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled {{ $lgAttribute->is_active ? 'checked' : '' }}>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.lgAttribute.fields.type') }}
                            </th>
                            <td>
                                {{ $lgAttribute->type_label }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.lgAttribute.fields.ledger_group') }}
                            </th>
                            <td>
                                @if($lgAttribute->ledgerGroup)
                                    <span class="badge badge-relationship">{{ $lgAttribute->ledgerGroup->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('lg_attribute_edit')
                    <a href="{{ route('admin.lg-attributes.edit', $lgAttribute) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.lg-attributes.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection