@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.lgAttributeValue.title_singular') }}:
                    {{ trans('cruds.lgAttributeValue.fields.id') }}
                    {{ $lgAttributeValue->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.lgAttributeValue.fields.id') }}
                            </th>
                            <td>
                                {{ $lgAttributeValue->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.lgAttributeValue.fields.ledger_group_attribute') }}
                            </th>
                            <td>
                                @if($lgAttributeValue->ledgerGroupAttribute)
                                    <span class="badge badge-relationship">{{ $lgAttributeValue->ledgerGroupAttribute->title ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.lgAttributeValue.fields.value') }}
                            </th>
                            <td>
                                {{ $lgAttributeValue->value }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.lgAttributeValue.fields.so') }}
                            </th>
                            <td>
                                {{ $lgAttributeValue->so }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('lg_attribute_value_edit')
                    <a href="{{ route('admin.lg-attribute-values.edit', $lgAttributeValue) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.lg-attribute-values.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection