@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.employeeInfo.title_singular') }}:
                    {{ trans('cruds.employeeInfo.fields.id') }}
                    {{ $employeeInfo->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.id') }}
                            </th>
                            <td>
                                {{ $employeeInfo->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.user') }}
                            </th>
                            <td>
                                @if($employeeInfo->user)
                                    <span class="badge badge-relationship">{{ $employeeInfo->user->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.first_name') }}
                            </th>
                            <td>
                                {{ $employeeInfo->first_name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.middle_name') }}
                            </th>
                            <td>
                                {{ $employeeInfo->middle_name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.last_name') }}
                            </th>
                            <td>
                                {{ $employeeInfo->last_name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.gender') }}
                            </th>
                            <td>
                                {{ $employeeInfo->gender_label }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.dob') }}
                            </th>
                            <td>
                                {{ $employeeInfo->dob }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.citizenship') }}
                            </th>
                            <td>
                                {{ $employeeInfo->citizenship }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.age') }}
                            </th>
                            <td>
                                {{ $employeeInfo->age }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.religion') }}
                            </th>
                            <td>
                                {{ $employeeInfo->religion }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.maritial_status') }}
                            </th>
                            <td>
                                {{ $employeeInfo->maritial_status_label }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.blood_group') }}
                            </th>
                            <td>
                                {{ $employeeInfo->blood_group }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.email') }}
                            </th>
                            <td>
                                <a class="link-light-blue" href="mailto:{{ $employeeInfo->email }}">
                                    <i class="far fa-envelope fa-fw">
                                    </i>
                                    {{ $employeeInfo->email }}
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.present_address_line_1') }}
                            </th>
                            <td>
                                {{ $employeeInfo->present_address_line_1 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.present_address_line_2') }}
                            </th>
                            <td>
                                {{ $employeeInfo->present_address_line_2 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.present_address_line_3') }}
                            </th>
                            <td>
                                {{ $employeeInfo->present_address_line_3 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.present_address_line_4') }}
                            </th>
                            <td>
                                {{ $employeeInfo->present_address_line_4 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.present_address_district') }}
                            </th>
                            <td>
                                {{ $employeeInfo->present_address_district }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.present_address_pin') }}
                            </th>
                            <td>
                                {{ $employeeInfo->present_address_pin }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.present_address_state') }}
                            </th>
                            <td>
                                {{ $employeeInfo->present_address_state }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.present_address_landmark') }}
                            </th>
                            <td>
                                {{ $employeeInfo->present_address_landmark }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.permanent_address_line_1') }}
                            </th>
                            <td>
                                {{ $employeeInfo->permanent_address_line_1 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.permanent_address_line_2') }}
                            </th>
                            <td>
                                {{ $employeeInfo->permanent_address_line_2 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.permanent_address_line_3') }}
                            </th>
                            <td>
                                {{ $employeeInfo->permanent_address_line_3 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.permanent_address_line_4') }}
                            </th>
                            <td>
                                {{ $employeeInfo->permanent_address_line_4 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.permanent_address_district') }}
                            </th>
                            <td>
                                {{ $employeeInfo->permanent_address_district }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.permanent_address_pin') }}
                            </th>
                            <td>
                                {{ $employeeInfo->permanent_address_pin }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.permanent_address_state') }}
                            </th>
                            <td>
                                {{ $employeeInfo->permanent_address_state }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.permanent_address_landmark') }}
                            </th>
                            <td>
                                {{ $employeeInfo->permanent_address_landmark }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.personal_phone') }}
                            </th>
                            <td>
                                {{ $employeeInfo->personal_phone }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.present_residence_phone') }}
                            </th>
                            <td>
                                {{ $employeeInfo->present_residence_phone }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.permanent_residence_phone') }}
                            </th>
                            <td>
                                {{ $employeeInfo->permanent_residence_phone }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.emergency_contact_1_name') }}
                            </th>
                            <td>
                                {{ $employeeInfo->emergency_contact_1_name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.emergency_contact_1_relation') }}
                            </th>
                            <td>
                                {{ $employeeInfo->emergency_contact_1_relation }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.emergency_contact_1_phone') }}
                            </th>
                            <td>
                                {{ $employeeInfo->emergency_contact_1_phone }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.emergency_contact_2_name') }}
                            </th>
                            <td>
                                {{ $employeeInfo->emergency_contact_2_name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.emergency_contact_2_relation') }}
                            </th>
                            <td>
                                {{ $employeeInfo->emergency_contact_2_relation }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.emergency_contact_2_phone') }}
                            </th>
                            <td>
                                {{ $employeeInfo->emergency_contact_2_phone }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.doj') }}
                            </th>
                            <td>
                                {{ $employeeInfo->doj }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.department') }}
                            </th>
                            <td>
                                {{ $employeeInfo->department }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.job_desgination') }}
                            </th>
                            <td>
                                @if($employeeInfo->jobDesgination)
                                    <span class="badge badge-relationship">{{ $employeeInfo->jobDesgination->title ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.esic') }}
                            </th>
                            <td>
                                {{ $employeeInfo->esic }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.uan') }}
                            </th>
                            <td>
                                {{ $employeeInfo->uan }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.aadhaar') }}
                            </th>
                            <td>
                                {{ $employeeInfo->aadhaar }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.salary_ac_no') }}
                            </th>
                            <td>
                                {{ $employeeInfo->salary_ac_no }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.salary_ac_bank') }}
                            </th>
                            <td>
                                {{ $employeeInfo->salary_ac_bank }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.salary_ac_ifsc') }}
                            </th>
                            <td>
                                {{ $employeeInfo->salary_ac_ifsc }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.pm_basic_salary') }}
                            </th>
                            <td>
                                {{ $employeeInfo->pm_basic_salary }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.pm_hra') }}
                            </th>
                            <td>
                                {{ $employeeInfo->pm_hra }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.pm_pf') }}
                            </th>
                            <td>
                                {{ $employeeInfo->pm_pf }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.pm_esic') }}
                            </th>
                            <td>
                                {{ $employeeInfo->pm_esic }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeInfo.fields.pm_ptax') }}
                            </th>
                            <td>
                                {{ $employeeInfo->pm_ptax }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('employee_info_edit')
                    <a href="{{ route('admin.employee-infos.edit', $employeeInfo) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.employee-infos.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection