@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.employeeEducationalInfo.title_singular') }}:
                    {{ trans('cruds.employeeEducationalInfo.fields.id') }}
                    {{ $employeeEducationalInfo->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.employeeEducationalInfo.fields.id') }}
                            </th>
                            <td>
                                {{ $employeeEducationalInfo->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeEducationalInfo.fields.employee_info') }}
                            </th>
                            <td>
                                @if($employeeEducationalInfo->employeeInfo)
                                    <span class="badge badge-relationship">{{ $employeeEducationalInfo->employeeInfo->first_name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeEducationalInfo.fields.degree_name') }}
                            </th>
                            <td>
                                {{ $employeeEducationalInfo->degree_name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeEducationalInfo.fields.year') }}
                            </th>
                            <td>
                                {{ $employeeEducationalInfo->year }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeEducationalInfo.fields.board_name') }}
                            </th>
                            <td>
                                {{ $employeeEducationalInfo->board_name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeEducationalInfo.fields.subjects') }}
                            </th>
                            <td>
                                {{ $employeeEducationalInfo->subjects }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeEducationalInfo.fields.grade') }}
                            </th>
                            <td>
                                {{ $employeeEducationalInfo->grade }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeEducationalInfo.fields.course_type') }}
                            </th>
                            <td>
                                {{ $employeeEducationalInfo->course_type_label }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('employee_educational_info_edit')
                    <a href="{{ route('admin.employee-educational-infos.edit', $employeeEducationalInfo) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.employee-educational-infos.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection