@extends('layouts.admin')
@section('content')
    <div class="row">
        <div class="card bg-blueGray-100">
            <div class="card-header">
                <div class="card-header-container">
                    <h6 class="card-title">
                        {{ trans('global.view') }}
                        {{ trans('cruds.employeeAttendanceLog.title_singular') }}:
                        {{ trans('cruds.employeeAttendanceLog.fields.id') }}
                        {{ $employeeAttendanceLog->id }}
                    </h6>
                </div>
            </div>

            <div class="card-body">
                <div class="pt-3">
                    <table class="table table-view">
                        <tbody class="bg-white">
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.id') }}
                                </th>
                                <td>
                                    {{ $employeeAttendanceLog->id }}
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.date') }}
                                </th>
                                <td>
                                    {{ $employeeAttendanceLog->date }}
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.user') }}
                                </th>
                                <td>
                                    @if ($employeeAttendanceLog->user)
                                        <span
                                            class="badge badge-relationship">{{ $employeeAttendanceLog->user->name ?? '' }}</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.type') }}
                                </th>
                                <td>
                                    {{ $employeeAttendanceLog->type_label }}
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.coord_lat') }}
                                </th>
                                <td>
                                    {{ $employeeAttendanceLog->coord_lat }}
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.coord_long') }}
                                </th>
                                <td>
                                    {{ $employeeAttendanceLog->coord_long }}
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.coord_accu') }}
                                </th>
                                <td>
                                    {{ $employeeAttendanceLog->coord_accu }}
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.location') }}
                                </th>
                                <td>
                                    {{ $employeeAttendanceLog->location }}
                                </td>
                            </tr>


                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.signed_in_at') }}
                                </th>
                                <td>
                                    {{ $employeeAttendanceLog->signed_in_at }}
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.signed_out_at') }}
                                </th>
                                <td>
                                    {{ $employeeAttendanceLog->signed_out_at }}
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.sign_in_photo') }}
                                </th>
                                <td>
                                    @foreach ($employeeAttendanceLog->sign_in_photo as $key => $entry)
                                        <a class="link-photo" href="{{ $entry['url'] }}">
                                            <img src="{{ $entry['preview_thumbnail'] }}" alt="{{ $entry['name'] }}"
                                                title="{{ $entry['name'] }}">
                                        </a>
                                    @endforeach
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.sign_out_photo') }}
                                </th>
                                <td>
                                    @foreach ($employeeAttendanceLog->sign_out_photo as $key => $entry)
                                        <a class="link-photo" href="{{ $entry['url'] }}">
                                            <img src="{{ $entry['preview_thumbnail'] }}" alt="{{ $entry['name'] }}"
                                                title="{{ $entry['name'] }}">
                                        </a>
                                    @endforeach
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.device') }}
                                </th>
                                <td>
                                    {{ $employeeAttendanceLog->device }}
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.attendance_from') }}
                                </th>
                                <td>
                                    {{ $employeeAttendanceLog->attendance_from_label }}
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    {{ trans('cruds.employeeAttendanceLog.fields.task') }}
                                </th>
                                <td>
                                    @foreach ($employeeAttendanceLog->task as $key => $entry)
                                        <span class="badge badge-relationship">{{ $entry->name }}</span>
                                    @endforeach
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="form-group">
                    @can('employee_attendance_log_edit')
                        <a href="{{ route('admin.employee-attendance-logs.edit', $employeeAttendanceLog) }}"
                            class="btn btn-indigo mr-2">
                            {{ trans('global.edit') }}
                        </a>
                    @endcan
                    <a href="{{ route('admin.employee-attendance-logs.index') }}" class="btn btn-secondary">
                        {{ trans('global.back') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection
