@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.clientBranch.title_singular') }}:
                    {{ trans('cruds.clientBranch.fields.id') }}
                    {{ $clientBranch->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.clientBranch.fields.id') }}
                            </th>
                            <td>
                                {{ $clientBranch->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientBranch.fields.name') }}
                            </th>
                            <td>
                                {{ $clientBranch->name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientBranch.fields.address') }}
                            </th>
                            <td>
                                {{ $clientBranch->address }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientBranch.fields.email') }}
                            </th>
                            <td>
                                {{ $clientBranch->email }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientBranch.fields.phone') }}
                            </th>
                            <td>
                                {{ $clientBranch->phone }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientBranch.fields.phone_2') }}
                            </th>
                            <td>
                                {{ $clientBranch->phone_2 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                Circle
                            </th>
                            <td>
                                @if($clientBranch->circle)
                                    <span class="badge badge-relationship">{{ $clientBranch->circle->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        {{-- <tr>
                            <th>
                                {{ trans('cruds.clientBranch.fields.region') }}
                            </th>
                            <td>
                                @if($clientBranch->region)
                                    <span class="badge badge-relationship">{{ $clientBranch->region->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr> --}}
                        <tr>
                            <th>
                                {{ trans('cruds.clientBranch.fields.full_name') }}
                            </th>
                            <td>
                                {{ $clientBranch->full_name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientBranch.fields.latitude') }}
                            </th>
                            <td>
                                {{ $clientBranch->latitude }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientBranch.fields.longitude') }}
                            </th>
                            <td>
                                {{ $clientBranch->longitude }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientBranch.fields.solid_code') }}
                            </th>
                            <td>
                                {{ $clientBranch->solid_code }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('client_branch_edit')
                    <a href="{{ route('admin.client-branches.edit', $clientBranch) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.client-branches.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
