@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.circle.title_singular') }}:
                    {{ trans('cruds.circle.fields.id') }}
                    {{ $circle->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.circle.fields.id') }}
                            </th>
                            <td>
                                {{ $circle->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.circle.fields.name') }}
                            </th>
                            <td>
                                {{ $circle->name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.circle.fields.is_active') }}
                            </th>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled {{ $circle->is_active ? 'checked' : '' }}>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.circle.fields.zone') }}
                            </th>
                            <td>
                                @if($circle->zone)
                                    <span class="badge badge-relationship">{{ $circle->zone->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        {{-- <tr>
                            <th>
                                {{ trans('cruds.circle.fields.state') }}
                            </th>
                            <td>
                                @if($circle->state)
                                    <span class="badge badge-relationship">{{ $circle->state->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr> --}}
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('circle_edit')
                    <a href="{{ route('admin.circles.edit', $circle) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.circles.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
