@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.circleProductPivot.title_singular') }}:
                    {{ trans('cruds.circleProductPivot.fields.id') }}
                    {{ $circleProductPivot->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.circleProductPivot.fields.id') }}
                            </th>
                            <td>
                                {{ $circleProductPivot->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.circleProductPivot.fields.product') }}
                            </th>
                            <td>
                                @if($circleProductPivot->product)
                                    <span class="badge badge-relationship">{{ $circleProductPivot->product->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.circleProductPivot.fields.circle') }}
                            </th>
                            <td>
                                @if($circleProductPivot->circle)
                                    <span class="badge badge-relationship">{{ $circleProductPivot->circle->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.circleProductPivot.fields.quantity') }}
                            </th>
                            <td>
                                {{ $circleProductPivot->quantity }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.circleProductPivot.fields.price') }}
                            </th>
                            <td>
                                {{ $circleProductPivot->price }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.circleProductPivot.fields.last_updated_by') }}
                            </th>
                            <td>
                                @if($circleProductPivot->lastUpdatedBy)
                                    <span class="badge badge-relationship">{{ $circleProductPivot->lastUpdatedBy->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('circle_product_pivot_edit')
                    <a href="{{ route('admin.circle-product-pivots.edit', $circleProductPivot) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.circle-product-pivots.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection