<?php

namespace Database\Seeders;

use App\Models\TaskStatus;
use Illuminate\Database\Seeder;

class TaskStatusTableSeeder extends Seeder
{
    public function run()
    {
        $taskStatuses = [
            [
                'id'   => TaskStatus::STATUS_OPEN,
                'name' => 'Open',
            ],
            [
                'id'   => TaskStatus::STATUS_IN_PROGRESS,
                'name' => 'In progress',
            ],
            [
                // 'id'   => 3,
                'id'   => TaskStatus::STATUS_CLOSED,
                'name' => 'Closed',
            ],
            [
                // 'id'   => 3,
                'id'   => TaskStatus::STATUS_NEED_ANOTHER_VISIT,
                'name' => 'Need Another Visit',
            ],
            [
                // 'id'   => 3,
                'id'   => TaskStatus::STATUS_PRODUCTS_ORDERED,
                'name' => 'Products Ordered',
            ],
            [
                // 'id'   => 3,
                'id'   => TaskStatus::STATUS_PRODUCTS_SENT,
                'name' => 'Products Sent',
            ],
        ];

        TaskStatus::insert($taskStatuses);
    }
}
