<?php

namespace Database\Seeders;

use App\Http\Controllers\Admin\Seeder001Controller;
use App\Models\KVSetting;
use App\Models\Role;
use Database\Factories\UserFactory;
use Illuminate\Database\Seeder;

class DummyDataSeeder extends Seeder
{




    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $faker = \Faker\Factory::create();

        // KVSetting::KVSettingSeeder();
        $roles = Role::whereNotIn('title', ['Admin', 'User'])->get();
        UserFactory::times(5)->create()->each(function ($user) use ($faker, $roles) {
            $user->roles()->attach($faker->randomElement($roles));
        });

        Seeder001Controller::SeedStatesAndZones();
    }
}
