<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOInvoiceItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('o_invoice_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('o_invoice_id')->nullable();
            $table->string('name')->nullable();
            $table->text('description')->nullable();
            $table->double('price', 15, 2)->nullable();
            $table->integer('quantity')->nullable();
            $table->boolean('is_taxable');
            $table->double('discount', 15, 2)->nullable();
            $table->double('subtotal', 15, 2)->nullable();
            $table->double('total', 15, 2)->nullable();
            $table->double('tax_amount', 15, 2)->nullable();
            $table->double('tax_perc', 15, 2)->nullable();
            $table->string('type')->nullable(); // product,service,other
            $table->json('extras')->nullable();
            $table->json('additional')->nullable();
            $table->json('tax_infos')->nullable();
            $table->morphs('invoiceable');
            $table->timestamps();
            $table->softDeletes();

            // $table->foreign('invoice_id')->references('id')->on('invoices')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    // public function down()
    // {
    //     Schema::dropIfExists('o_invoice_items');
    // }
}
