<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('o_invoices', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('fin_yr_id')->nullable();
            $table->string('slno')->nullable();
            $table->string('invoice_no')->nullable();
            $table->foreignId('client_group_id')->nullable();
            $table->foreignId('client_id')->nullable();
            $table->date('date')->nullable();
            $table->date('due_date')->nullable();
            $table->string('client_name')->nullable();
            $table->string('client_address')->nullable();
            $table->string('client_email')->nullable();
            $table->string('client_phone')->nullable();
            $table->double('subtotal', 15, 2)->nullable();
            $table->double('taxes', 15, 2)->nullable();
            $table->double('due', 15, 2)->nullable();
            $table->double('total', 15, 2)->nullable();
            $table->text('notes')->nullable();
            $table->json('extras')->nullable();
            $table->json('additional')->nullable();
            $table->json('tax_infos')->nullable();
            $table->string('status')->nullable();
            $table->morphs('invoiced_to');
            $table->morphs('invoiced_by');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    // public function down()
    // {
    //     Schema::dropIfExists('o_invoices');
    // }
}
