<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRelationshipFieldsToProductTaskEventLogsTable extends Migration
{
    public function up()
    {
        Schema::table('product_task_event_logs', function (Blueprint $table) {
            $table->unsignedBigInteger('task_event_log_id')->nullable();
            $table->foreign('task_event_log_id', 'task_event_log_fk_7606254')->references('id')->on('task_event_logs');
            $table->unsignedBigInteger('product_id')->nullable();
            $table->foreign('product_id', 'product_fk_7606255')->references('id')->on('products');
            $table->unsignedBigInteger('approved_by_id')->nullable();
            $table->foreign('approved_by_id', 'approved_by_fk_7606258')->references('id')->on('users');
        });
    }
}
