<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRelationshipFieldsToCircleProductPivotsTable extends Migration
{
    public function up()
    {
        Schema::table('circle_product_pivots', function (Blueprint $table) {
            $table->unsignedBigInteger('product_id')->nullable();
            $table->foreign('product_id', 'product_fk_7605027')->references('id')->on('products');
            $table->unsignedBigInteger('circle_id')->nullable();
            $table->foreign('circle_id', 'circle_fk_7605028')->references('id')->on('circles');
            $table->unsignedBigInteger('last_updated_by_id')->nullable();
            $table->foreign('last_updated_by_id', 'last_updated_by_fk_7605031')->references('id')->on('users');
        });
    }
}
