<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMonthlyPayslipsTable extends Migration
{
    public function up()
    {
        Schema::create('monthly_payslips', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('year');
            $table->string('month');
            $table->string('emp_code')->nullable();
            $table->string('location')->nullable();
            $table->string('name')->nullable();
            $table->string('payment_mode')->nullable();
            $table->string('bank')->nullable();
            $table->string('bank_ac_no')->nullable();
            $table->string('aadhaar')->nullable();
            $table->string('blood_group')->nullable();
            $table->integer('days_in_month')->nullable();
            $table->integer('lwp_days')->nullable();
            $table->integer('working_days')->nullable();
            $table->string('esic_no')->nullable();
            $table->string('uan')->nullable();
            $table->decimal('basic_salary', 15, 2)->nullable();
            $table->decimal('hra', 15, 2)->nullable();
            $table->decimal('ta', 15, 2)->nullable();
            $table->decimal('incentive', 15, 2)->nullable();
            $table->decimal('total_earning', 15, 2)->nullable();
            $table->decimal('pf', 15, 2)->nullable();
            $table->decimal('ptax', 15, 2)->nullable();
            $table->decimal('esic', 15, 2)->nullable();
            $table->decimal('total_deduction', 15, 2)->nullable();
            $table->string('total_payment')->nullable();
            $table->string('payment_status')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }
}
