<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeInfosTable extends Migration
{
    public function up()
    {
        Schema::create('employee_infos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('first_name')->nullable();
            $table->string('middle_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('gender')->nullable();
            $table->date('dob')->nullable();
            $table->string('citizenship')->nullable();
            $table->float('age', 15, 2)->nullable();
            $table->string('religion')->nullable();
            $table->string('maritial_status')->nullable();
            $table->string('blood_group')->nullable();
            $table->string('email')->nullable();
            $table->string('present_address_line_1')->nullable();
            $table->string('present_address_line_2')->nullable();
            $table->string('present_address_line_3')->nullable();
            $table->string('present_address_line_4')->nullable();
            $table->string('present_address_district')->nullable();
            $table->string('present_address_pin')->nullable();
            $table->string('present_address_state')->nullable();
            $table->string('present_address_landmark')->nullable();
            $table->string('permanent_address_line_1')->nullable();
            $table->string('permanent_address_line_2')->nullable();
            $table->string('permanent_address_line_3')->nullable();
            $table->string('permanent_address_line_4')->nullable();
            $table->string('permanent_address_district')->nullable();
            $table->string('permanent_address_pin')->nullable();
            $table->string('permanent_address_state')->nullable();
            $table->string('permanent_address_landmark')->nullable();
            $table->string('personal_phone')->nullable();
            $table->string('present_residence_phone')->nullable();
            $table->string('permanent_residence_phone')->nullable();
            $table->string('emergency_contact_1_name')->nullable();
            $table->string('emergency_contact_1_relation')->nullable();
            $table->string('emergency_contact_1_phone')->nullable();
            $table->string('emergency_contact_2_name')->nullable();
            $table->string('emergency_contact_2_relation')->nullable();
            $table->string('emergency_contact_2_phone')->nullable();
            $table->date('doj')->nullable();
            $table->string('department')->nullable();
            $table->string('esic')->nullable();
            $table->string('uan')->nullable();
            $table->string('aadhaar')->nullable();
            $table->string('salary_ac_no')->nullable();
            $table->string('salary_ac_bank')->nullable();
            $table->string('salary_ac_ifsc')->nullable();
            $table->decimal('pm_basic_salary', 15, 2)->nullable();
            $table->decimal('pm_hra', 15, 2)->nullable();
            $table->decimal('pm_pf', 15, 2)->nullable();
            $table->decimal('pm_esic', 15, 2)->nullable();
            $table->decimal('pm_ptax', 15, 2)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }
}
