<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRelationshipFieldsToTaskEventLogsTable extends Migration
{
    public function up()
    {
        Schema::table('task_event_logs', function (Blueprint $table) {
            $table->unsignedBigInteger('task_id')->nullable();
            $table->foreign('task_id', 'task_fk_7524515')->references('id')->on('tasks');
            $table->unsignedBigInteger('logged_by_id')->nullable();
            $table->foreign('logged_by_id', 'logged_by_fk_7524516')->references('id')->on('users');
            $table->unsignedBigInteger('assigned_to_id')->nullable();
            $table->foreign('assigned_to_id', 'assigned_to_fk_7531007')->references('id')->on('users');
        });
    }
}
