<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeAttendanceLogsTable extends Migration
{
    public function up()
    {
        Schema::create('employee_attendance_logs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->date('date');
            $table->string('type')->nullable();
            $table->string('coord_lat')->nullable();
            $table->string('coord_long')->nullable();
            $table->string('coord_accu')->nullable();
            $table->longText('location')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('employee_attendance_logs');
    }
}
