<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLedgerTransactionsTable extends Migration
{
    public function up()
    {
        Schema::create('ledger_transactions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->datetime('date')->nullable();
            $table->decimal('amount', 15, 2)->nullable();
            $table->string('type');
            $table->decimal('cr_bal_before', 15, 2)->nullable();
            $table->decimal('dr_bal_before', 15, 2)->nullable();
            $table->decimal('cr_bal_after', 15, 2)->nullable();
            $table->decimal('dr_bal_after', 15, 2)->nullable();
            $table->longText('description')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('ledger_transactions');
    }
}
