<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePurchasesTable extends Migration
{
    public function up()
    {
        Schema::create('purchases', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('suply_invc_no')->nullable();
            $table->date('prchs_date')->nullable();
            $table->string('party_ac')->nullable();
            $table->decimal('total_invoic', 15, 2)->nullable();
            $table->decimal('csgt_amt', 15, 2)->nullable();
            $table->decimal('sgst_amt', 15, 2)->nullable();
            $table->decimal('igst_amt', 15, 2)->nullable();
            $table->decimal('invoice_total_wo_tax', 15, 2)->nullable();
            $table->string('details')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('purchases');
    }
}
