<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('email')->unique();
            $table->datetime('email_verified_at')->nullable();
            $table->string('password');
            $table->string('remember_token')->nullable();
            $table->string('locale')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->string('phone')->nullable();
            $table->string('username')->nullable();
            $table->string('employee_code')->nullable();
            $table->boolean('is_active')->default(0)->nullable();
            $table->datetime('last_password_changed_at')->nullable();
        });
    }

    public function down()
    {
        Schema::dropIfExists('users');
    }
}
