<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaskStatus extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;

    public const STATUS_OPEN                 =   1;
    public const STATUS_IN_PROGRESS          =   2;
    public const STATUS_CLOSED               =   3;
    public const STATUS_NEED_ANOTHER_VISIT   =   4;
    public const STATUS_PRODUCTS_ORDERED     =   5;
    public const STATUS_PRODUCTS_SENT        =   6;
    /*
    id	name
    1	Open
    2	In progress
    3	Closed
    4	Need Another Visit
    5	Products Ordered
    6	Products Sent
    */


    public $table = 'task_statuses';

    public $orderable = [
        'id',
        'name',
    ];

    public $filterable = [
        'id',
        'name',
    ];

    protected $fillable = [
        'name',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
