<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class State extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public $table = 'states';

    public $filterable = [
        'id',
        'name',
        'region.name',
        // 'zone.name',
    ];

    public $orderable = [
        'id',
        'name',
        'is_active',
        'region.name',
        // 'zone.name',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    protected $fillable = [
        'name',
        'is_active',
        'region_id',
        // 'zone_id',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    // public function zone()
    // {
    //     return $this->belongsTo(Zone::class);
    // }
    // public function circles()
    // {
    //     return $this->hasMany(Circle::class);
    // }
    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function region()
    {
        return $this->belongsTo(Region::class);
    }

    public function zones()
    {
        return $this->hasMany(Zone::class);
    }
}
