<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;

    public const ROLE_ADMIN_ID = 1;
    public const ROLE_USER_ID = 2;
    public const ROLE_CIRCLE_OFFICER_ID = 3;
    public const ROLE_ENGINEER_HEAD_ID = 4;
    public const ROLE_ENGINEER_ID = 5;
    public const ROLE_CLIENT_OM_ID = 6;
    public const ROLE_CLIENT_ZO_ID = 7;


    public $rolesx = [
        [
            "id" => "1",
            "title" => "Admin"
        ],
        [
            "id" => "2",
            "title" => "User"
        ],
        [
            "id" => "3",
            "title" => "Circle Officer"
        ],
        [
            "id" => "4",
            "title" => "Engineer (Regional Head)"
        ],
        [
            "id" => "5",
            "title" => "Engineer"
        ],
        [
            "id" => "6",
            "title" => "ClientOM"
        ]
    ];

    public $table = 'roles';

    public $orderable = [
        'id',
        'title',
    ];

    public $filterable = [
        'id',
        'title',
        'permissions.title',
    ];

    protected $fillable = [
        'title',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public function permissions()
    {
        return $this->belongsToMany(Permission::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class);
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public static function appLoginArray()
    {
        return [
            Role::ROLE_ADMIN_ID,
            Role::ROLE_USER_ID,
            Role::ROLE_CIRCLE_OFFICER_ID,
            Role::ROLE_ENGINEER_HEAD_ID,
            Role::ROLE_ENGINEER_ID,
            Role::ROLE_CLIENT_ZO_ID,
        ];
    }
}
