<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class Region extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;
    use \Staudenmeir\EloquentHasManyDeep\HasTableAlias;

    public $table = 'regions';

    public $filterable = [
        'id',
        'name',
        // 'circle.name',
    ];

    public $orderable = [
        'id',
        'name',
        'is_active',
        // 'circle.name',
        'engineer.name',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    protected $fillable = [
        'name',
        'is_active',
        'circle_id',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    // public function circle()
    // {
    //     return $this->belongsTo(Circle::class);
    // }

    // public function engineer2()
    // {
    //     // $userIds =  DB::table('role_user')->select('user_id')->whereIn('role_id', [4, 5])->get()->pluck('user_id')->toArray();
    //     // return $this->belongsToMany(User::class)->setAlias('eng')->whereIn('user_id', $userIds);

    //     return $this->engineer()->setAlias('eng');
    // }

    // public function engineer()
    // {
    //     $userIds =  DB::table('role_user')->select('user_id')->whereIn('role_id', [4, 5])->get()->pluck('user_id')->toArray();
    //     return $this->belongsToMany(User::class)
    //         // ->setAlias('eng')
    //         ->whereIn('user_id', $userIds);
    // }


    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function states()
    {
        return $this->hasMany(State::class);
    }
}
