<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\Pivot;

class ProductZonePivot extends Pivot
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;

    public $table = 'product_zone_pivots';

    public $orderable = [
        'id',
        'product.name',
        'product.price',
        'zone.name',
        'quantity',
        'price',
        'last_updated_by.name',
    ];

    public $filterable = [
        'id',
        'product.name',
        'product.price',
        'zone.name',
        'quantity',
        'price',
        'last_updated_by.name',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'product_id',
        'zone_id',
        'quantity',
        'price',
        'last_updated_by_id',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function zone()
    {
        return $this->belongsTo(Zone::class);
    }

    public function lastUpdatedBy()
    {
        return $this->belongsTo(User::class);
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
