<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\Pivot;

class ProductZoneHistory extends Pivot
{
    protected $table = 'product_zone_history';

    protected $fillable = [
        'product_id',
        'zone_id',
        'quantity',
        'quantity_before',
        'action',
        'updated_by_id',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function zone()
    {
        return $this->belongsTo(Zone::class);
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by_id');
    }
}
