<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Arr;

class MonthlyPayslip extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public const YEAR_SELECT = [
        '2020' => '2020',
        '2021' => '2021',
        '2022' => '2022',
    ];

    public static function getYearsSelect()
    {
        $from = 2015;
        $upto = now()->year;
        $rangeArr = collect(range($from, $upto))

            // ->reverse()
            ->toArray();

        // return collect($rangeArr)
        //     // ->reverse()
        //     // ->sort()
        //     // ->sortDesc()
        //     ->mapWithKeys(function ($d) {
        //         return [(string)$d => $d];
        //     })->toArray();
        $years = [];
        foreach ($rangeArr as $year) {
            $years[$year] = $year;
            // $years[] = $year;
        }
        krsort($years, SORT_NUMERIC);
        return $years;
    }

    public static function getYearsSelectSequential()
    {
        $from = 2015;
        $upto = now()->year;
        $rangeArr = collect(range($from, $upto))

            ->reverse()
            ->toArray();

        // return collect($rangeArr)
        //     // ->reverse()
        //     // ->sort()
        //     // ->sortDesc()
        //     ->mapWithKeys(function ($d) {
        //         return [(string)$d => $d];
        //     })->toArray();
        $years = [];
        foreach ($rangeArr as $year) {
            $years[$year] = $year;
            // $years[] = $year;
        }
        // krsort($years, SORT_NUMERIC);
        return $years;
    }
    public static function getMonthsSelect()
    {
        $from = 1;
        $upto = 12;
        $time = now();
        $rangeArr = collect(range($from, $upto))

            // ->reverse()
            ->toArray();

        // return collect($rangeArr)
        //     // ->reverse()
        //     // ->sort()
        //     // ->sortDesc()
        //     ->mapWithKeys(function ($d) {
        //         return [(string)$d => $d];
        //     })->toArray();
        $months = [];
        foreach ($rangeArr as $month) {
            $months[$month] = $time->month($month)->format('F');
            // $years[] = $year;
        }
        // krsort($years, SORT_NUMERIC);
        return $months;
    }

    public const MONTH_SELECT = [
        '1' => 'January',
        '2' => 'February',
        '3' => 'March',
    ];

    public const PAYMENT_STATUS_SELECT = [
        'Initiated'  => 'Initiated',
        'Pending'    => 'Pending',
        'Processing' => 'Processing',
        'Completed'  => 'Completed',
    ];
    /**
     * The accessors to append to the model's array form.
     *
     * @var array
     */
    protected $appends = ['pdf_url', 'year_label', 'month_label'];

    public $table = 'monthly_payslips';

    public $orderable = [
        'id',
        'fin_yr.title',
        'fin_yr.alias',
        'year',
        'month',
        'user.name',
        'emp_code',
        'location',
        'name',
        'payment_mode',
        'bank',
        'bank_ac_no',
        'aadhaar',
        'blood_group',
        'days_in_month',
        'lwp_days',
        'working_days',
        'esic_no',
        'uan',
        'basic_salary',
        'hra',
        'ta',
        'incentive',
        'total_earning',
        'pf',
        'ptax',
        'esic',
        'total_deduction',
        'total_payment',
        'payment_status',
    ];

    public $filterable = [
        'id',
        'fin_yr.title',
        'fin_yr.alias',
        'year',
        'month',
        'user.name',
        'emp_code',
        'location',
        'name',
        'payment_mode',
        'bank',
        'bank_ac_no',
        'aadhaar',
        'blood_group',
        'days_in_month',
        'lwp_days',
        'working_days',
        'esic_no',
        'uan',
        'basic_salary',
        'hra',
        'ta',
        'incentive',
        'total_earning',
        'pf',
        'ptax',
        'esic',
        'total_deduction',
        'total_payment', // net
        'gross_salary',
        'payment_status',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'fin_yr_id',
        'year',
        'month',
        'user_id',
        'emp_code',
        'location',
        'name',
        'payment_mode',
        'bank',
        'bank_ac_no',
        'aadhaar',
        'blood_group',
        'days_in_month',
        'lwp_days',
        'working_days',
        'esic_no',
        'uan',
        'basic_salary',
        'hra',
        'ta',
        'incentive',
        'total_earning',
        'pf',
        'ptax',
        'esic',
        'total_deduction',
        'total_payment',
        'payment_status',
        'gross_salary',
    ];

    public function finYr()
    {
        return $this->belongsTo(FinYr::class);
    }

    public function getYearLabelAttribute($value)
    {
        return static::getYearsSelect()[$this->year] ?? null;
        // return static::YEAR_SELECT[$this->year] ?? null;
    }

    public function getMonthLabelAttribute($value)
    {
        return static::getMonthsSelect()[$this->month] ?? null;
        // return static::MONTH_SELECT[$this->month] ?? null;
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getPaymentStatusLabelAttribute($value)
    {
        return static::PAYMENT_STATUS_SELECT[$this->payment_status] ?? null;
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    # fin_yr_title
    public function getFinYrTitleAttribute($value)
    {
        return $this->finYr?->title;
        // return static::YEAR_SELECT[$this->year] ?? null;
    }

    #accessor pdf_url
    public function getPdfUrlAttribute()
    {
        if ($this->id && $this->user_id) {
            return route('monthly-payslip.export', [
                'user' => $this->user_id,
                'payslip' => $this->id,
                'mode' => 'pdf',
            ]);
        }
    }

    #accessor fin_month
    public function getFinMonthAttribute()
    {
        $fm = Carbon::createFromDate($this->year, $this->month);
        return $fm;
    }

    #accessor fin_month_f
    public function getFinMonthFAttribute()
    {
        $fm = $this->getFinMonthAttribute();
        return strtoupper($fm->format('M\'Y'));
    }
}
