<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LedgerGroup extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public $table = 'ledger_groups';

    public $orderable = [
        'id',
        'name',
        'purpose',
    ];

    public $filterable = [
        'id',
        'name',
        'purpose',
    ];

    protected $fillable = [
        'name',
        'purpose',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
    public function ledgerattres()
    {
        return $this->hasMany(LgAttribute::class);
    }
}
