<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ledger extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public $table = 'ledgers';

    public $orderable = [
        'id',
        'name',
        'description',
        'ledger_group.name',
    ];

    public $filterable = [
        'id',
        'name',
        'description',
        'ledger_group.name',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'name',
        'description',
        'ledger_group_id',
    ];

    public function ledgerGroup()
    {
        return $this->belongsTo(LedgerGroup::class);
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
    public function taxProducts()
    {
        return $this->belongsToMany(Product::class)->withPivot('rate');
    }
}
