<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeInfo extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;

    public const GENDER_RADIO = [
        'male'   => 'Male',
        'female' => 'Female',
    ];

    public const MARITIAL_STATUS_SELECT = [
        'unmarried' => 'Unmarried',
        'married'   => 'Married',
        'widowed'   => 'Widowed',
        'separated' => 'separated',
    ];

    public $table = 'employee_infos';

    public $orderable = [
        'id',
        'user.name',
        'first_name',
        'middle_name',
        'last_name',
        'gender',
        'dob',
        'citizenship',
        'age',
        'religion',
        'maritial_status',
        'blood_group',
        'email',
        'present_address_line_1',
        'present_address_line_2',
        'present_address_line_3',
        'present_address_line_4',
        'present_address_district',
        'present_address_pin',
        'present_address_state',
        'present_address_landmark',
        'permanent_address_line_1',
        'permanent_address_line_2',
        'permanent_address_line_3',
        'permanent_address_line_4',
        'permanent_address_district',
        'permanent_address_pin',
        'permanent_address_state',
        'permanent_address_landmark',
        'personal_phone',
        'present_residence_phone',
        'permanent_residence_phone',
        'emergency_contact_1_name',
        'emergency_contact_1_relation',
        'emergency_contact_1_phone',
        'emergency_contact_2_name',
        'emergency_contact_2_relation',
        'emergency_contact_2_phone',
        'doj',
        'department',
        'job_desgination.title',
        'job_desgination.basic_salary',
        'esic',
        'uan',
        'aadhaar',
        'salary_ac_no',
        'salary_ac_bank',
        'salary_ac_ifsc',
        'pm_basic_salary',
        'pm_hra',
        'pm_pf',
        'pm_esic',
        'pm_ptax',
        'location',
        'payment_mode',
    ];

    public $filterable = [
        'id',
        'user.name',
        'first_name',
        'middle_name',
        'last_name',
        'gender',
        'dob',
        'citizenship',
        'age',
        'religion',
        'maritial_status',
        'blood_group',
        'email',
        'present_address_line_1',
        'present_address_line_2',
        'present_address_line_3',
        'present_address_line_4',
        'present_address_district',
        'present_address_pin',
        'present_address_state',
        'present_address_landmark',
        'permanent_address_line_1',
        'permanent_address_line_2',
        'permanent_address_line_3',
        'permanent_address_line_4',
        'permanent_address_district',
        'permanent_address_pin',
        'permanent_address_state',
        'permanent_address_landmark',
        'personal_phone',
        'present_residence_phone',
        'permanent_residence_phone',
        'emergency_contact_1_name',
        'emergency_contact_1_relation',
        'emergency_contact_1_phone',
        'emergency_contact_2_name',
        'emergency_contact_2_relation',
        'emergency_contact_2_phone',
        'doj',
        'department',
        'job_desgination.title',
        'job_desgination.basic_salary',
        'esic',
        'uan',
        'aadhaar',
        'salary_ac_no',
        'salary_ac_bank',
        'salary_ac_ifsc',
        'pm_basic_salary',
        'pm_hra',
        'pm_pf',
        'pm_esic',
        'pm_ptax',
        'location',
        'payment_mode',
    ];

    protected $dates = [
        'dob',
        'doj',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'user_id',
        'first_name',
        'middle_name',
        'last_name',
        'gender',
        'dob',
        'citizenship',
        'age',
        'religion',
        'maritial_status',
        'blood_group',
        'email',
        'present_address_line_1',
        'present_address_line_2',
        'present_address_line_3',
        'present_address_line_4',
        'present_address_district',
        'present_address_pin',
        'present_address_state',
        'present_address_landmark',
        'permanent_address_line_1',
        'permanent_address_line_2',
        'permanent_address_line_3',
        'permanent_address_line_4',
        'permanent_address_district',
        'permanent_address_pin',
        'permanent_address_state',
        'permanent_address_landmark',
        'personal_phone',
        'present_residence_phone',
        'permanent_residence_phone',
        'emergency_contact_1_name',
        'emergency_contact_1_relation',
        'emergency_contact_1_phone',
        'emergency_contact_2_name',
        'emergency_contact_2_relation',
        'emergency_contact_2_phone',
        'doj',
        'department',
        'job_desgination_id',
        'esic',
        'uan',
        'aadhaar',
        'pan`',
        'salary_ac_no',
        'salary_ac_bank',
        'salary_ac_ifsc',
        'pm_basic_salary',
        'pm_hra',
        'pm_pf',
        'pm_esic',
        'pm_ptax',
        'location',
        'payment_mode',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getGenderLabelAttribute($value)
    {
        return static::GENDER_RADIO[$this->gender] ?? null;
    }

    public function getDobAttribute($value)
    {
        return $value ? Carbon::parse($value)->format(config('project.date_format')) : null;
    }

    public function setDobAttribute($value)
    {
        $this->attributes['dob'] = $value ? Carbon::createFromFormat(config('project.date_format'), $value)->format('Y-m-d') : null;
    }

    public function getMaritialStatusLabelAttribute($value)
    {
        return static::MARITIAL_STATUS_SELECT[$this->maritial_status] ?? null;
    }

    public function getDojAttribute($value)
    {
        return $value ? Carbon::parse($value)->format(config('project.date_format')) : null;
    }

    public function setDojAttribute($value)
    {
        $this->attributes['doj'] = $value ? Carbon::createFromFormat(config('project.date_format'), $value)->format('Y-m-d') : null;
    }

    public function jobDesgination()
    {
        return $this->belongsTo(JobDesignation::class);
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }


    public function educationalDetails()
    {
        return $this->hasMany(EmployeeEducationalInfo::class);
    }

    public function familyDetails()
    {
        return $this->hasMany(EmployeeFamilyDetail::class);
    }

    public static function mapEmployeeInfoToPaySlip()
    {





        return [
            // 'emp_code' => '',
            'location' => 'location',
            'name' => 'name_formatted',
            'payment_mode' => 'payment_mode',
            'bank' => 'salary_ac_bank',
            'bank_ac_no' => 'salary_ac_no',
            'aadhaar' => 'aadhaar',
            'blood_group' => 'blood_group',
            // 'days_in_month' => '',
            // 'lwp_days' => '',
            // 'working_days' => '',
            'esic_no' => 'esic',
            'uan' => 'uan',
            'basic_salary' => 'pm_basic_salary',
            'hra' => 'pm_hra',
            // 'ta' => '',
            // 'incentive' => '',
            // 'total_earning' => '',
            'pf' => 'pm_pf',
            'ptax' => 'pm_ptax',
            'esic' => 'pm_esic',
        ];
    }

    #accessor name_formatted
    public function getNameFormattedAttribute()
    {
        $fn = trim($this->first_name);
        $mn = trim($this->middle_name);
        $ln = trim($this->last_name);
        $names = [];
        if (!empty($fn)) $names[] = $fn;
        if (!empty($mn)) $names[] = $mn;
        if (!empty($ln)) $names[] = $ln;

        return implode(" ", $names);
    }


    #accessor age
    public function getAgeAttribute()
    {
        return Carbon::parse($this->dob)->age;
    }
}
