<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeEducationalInfo extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;

    public const COURSE_TYPE_RADIO = [
        'Regular'        => 'Regular',
        'Open School'    => 'Open School',
        'Part Time'      => 'Part Time',
        'Correspondence' => 'Correspondence',
    ];
    // public static const COURSE_TYPE_RADIO_STATIC = [
    //     'Regular'        => 'Regular',
    //     'Open School'    => 'Open School',
    //     'Part Time'      => 'Part Time',
    //     'Correspondence' => 'Correspondence',
    // ];

    public $table = 'employee_educational_infos';

    public $orderable = [
        'id',
        'employee_info.first_name',
        'degree_name',
        'year',
        'board_name',
        'subjects',
        'grade',
        'course_type',
    ];

    public $filterable = [
        'id',
        'employee_info.first_name',
        'degree_name',
        'year',
        'board_name',
        'subjects',
        'grade',
        'course_type',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'employee_info_id',
        'degree_name',
        'year',
        'board_name',
        'subjects',
        'grade',
        'course_type',
    ];

    public function employeeInfo()
    {
        return $this->belongsTo(EmployeeInfo::class);
    }

    public function getCourseTypeLabelAttribute($value)
    {
        return static::COURSE_TYPE_RADIO[$this->course_type] ?? null;
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
