<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public $table = 'companies';

    public $orderable = [
        'id',
        'name',
        'mailing_name',
        'address_line_one',
        'address_line_two',
        'state',
        'city',
        'pin',
        'phone',
        'email',
        'mobile',
        'fax_no',
        'website',
        'gst_state',
        'registration_type',
        'gstin',
        'period_gstr_one',
        'eway_bill_is_applicable',
        'threshold_limit',
        'apply_for_inter_state',
        'inter_threshold_limit',
    ];

    public $filterable = [
        'id',
        'name',
        'mailing_name',
        'address_line_one',
        'address_line_two',
        'state',
        'city',
        'pin',
        'phone',
        'email',
        'mobile',
        'fax_no',
        'website',
        'gst_state',
        'registration_type',
        'gstin',
        'period_gstr_one',
        'eway_bill_is_applicable',
        'threshold_limit',
        'apply_for_inter_state',
        'inter_threshold_limit',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'name',
        'mailing_name',
        'address_line_one',
        'address_line_two',
        'state',
        'city',
        'pin',
        'phone',
        'email',
        'mobile',
        'fax_no',
        'website',
        'gst_state',
        'registration_type',
        'gstin',
        'period_gstr_one',
        'eway_bill_is_applicable',
        'threshold_limit',
        'apply_for_inter_state',
        'inter_threshold_limit',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
