<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientGroup extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public $table = 'client_groups';

    public $orderable = [
        'id',
        'name',
        'business_name',
        'address',
        'phone_1',
        'phone_2',
        'email_1',
        'email_2',
        'is_active',
        'has_multi_state_business',
    ];

    public $filterable = [
        'id',
        'name',
        'business_name',
        'address',
        'phone_1',
        'phone_2',
        'email_1',
        'email_2',
        'zone.name',
        'state.name',
        'circle.name',
        'operation_manager.name',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $casts = [
        'is_active'                => 'boolean',
        'has_multi_state_business' => 'boolean',
    ];

    protected $fillable = [
        'name',
        'business_name',
        'address',
        'phone_1',
        'phone_2',
        'email_1',
        'email_2',
        'is_active',
        'has_multi_state_business',
        'operation_manager_id',
    ];

    public function zone()
    {
        return $this->belongsToMany(Zone::class);
    }

    public function state()
    {
        return $this->belongsToMany(State::class);
    }

    public function circle()
    {
        return $this->belongsToMany(Circle::class);
    }

    public function operationManager()
    {
        return $this->belongsTo(User::class);
    }

    public function clients()
    {
        return $this->hasMany(Client::class);
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
