<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientBranch extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public $table = 'client_branches';

    public $orderable = [
        'id',
        'name',
        'address',
        'email',
        'phone',
        'phone_2',
        // 'region.name',
        'circle.name',
        'full_name',
        'latitude',
        'longitude',
        'solid_code',
        'client.name',
    ];

    public $filterable = [
        'id',
        'name',
        'address',
        'email',
        'phone',
        'phone_2',
        // 'region.name',
        'circle.name',
        'full_name',
        'latitude',
        'longitude',
        'solid_code',
        'client.name',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'name',
        'address',
        'email',
        'phone',
        'phone_2',
        // 'region_id',
        'circle_id',
        'full_name',
        'latitude',
        'longitude',
        'solid_code',
        'client_id',
    ];

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    // public function region()
    // {
    //     return $this->belongsTo(Region::class);
    // }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }


    // name_region
    public function getNameRegionAttribute()
    {
        // $name = $this->name;
        // if ($this->region) {
        //     $name .= " (" . $this->region->name . ")";
        // }
        // return $name;
        return $this->getNameCircleAttribute();
    }

    // name_circle
    public function getNameCircleAttribute()
    {
        $name = $this->name;
        if ($this->circle) {
            $name .= " (" . $this->circle->name . ")";
        }
        return $name;
    }


    public function circle()
    {
        return $this->belongsTo(Circle::class);
    }
}
