<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\Pivot;

class CircleProductHistory extends Pivot
{
    protected $table = 'circle_product_history';

    protected $fillable = [
        'product_id',
        'circle_id',
        'quantity',
        'quantity_before',
        'action',
        'updated_by_id',
        'zone_id',
        'additional',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function zone()
    {
        return $this->belongsTo(Zone::class);
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by_id');
    }

    public function circle()
    {
        return $this->belongsTo(Circle::class);
    }
}
