<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class Circle extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public $table = 'circles';

    public $filterable = [
        'id',
        'name',
        'state.name',
    ];

    public $orderable = [
        'id',
        'name',
        'is_active',
        'state.name',
        'circle_officer.name',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    protected $fillable = [
        'name',
        'is_active',
        'state_id',
        'circle_officer_id',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    // public function state()
    // {
    //     return $this->belongsTo(State::class);
    // }
    //
    // public function regions()
    // {
    //     return $this->hasMany(Region::class);
    // }

    public function circleOfficer()
    {
        return $this->belongsTo(User::class);
    }



    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }


    public function zone()
    {
        return $this->belongsTo(Zone::class);
    }



    public function clientBranches()
    {
        return $this->hasMany(ClientBranch::class);
    }

    public function client_branches()
    {
        return $this->clientBranches();
    }



    public function engineer2()
    {
        // $userIds =  DB::table('role_user')->select('user_id')->whereIn('role_id', [4, 5])->get()->pluck('user_id')->toArray();
        // return $this->belongsToMany(User::class)->setAlias('eng')->whereIn('user_id', $userIds);

        return $this->engineer()->setAlias('eng');
    }

    public function engineer()
    {
        // $userIds =  DB::table('role_user')->select('user_id')->whereIn('role_id', [4, 5])->get()->pluck('user_id')->toArray();
        return $this->belongsToMany(User::class)
            // ->setAlias('eng')
            ->whereHas('roles', function ($query) {
                $query->whereIn('roles.id', [4, 5]);
            });
        // ->whereIn('user_id', $userIds);
    }

    // belongsToMany products
    public function products()
    {
        return $this->belongsToMany(Product::class, 'circle_product_pivots')
            ->withPivot(['quantity', 'price']);
    }

    /**
     * Get the product requisitions for the circle.
     */
    public function productRequestedToMe()
    {
        return $this->morphMany(ProductRequisition::class, 'requested_to');
    }

    /**
     * Get the product requisitions for the circle.
     */
    public function productRequestedForMe()
    {
        return $this->morphMany(ProductRequisition::class, 'requested_for');
    }
}
