<?php

namespace App\Http\Requests;

use App\Models\VisitRoute;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateVisitRouteRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('visit_route_edit'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'from' => [
                'string',
                'max:255',
                'nullable',
            ],
            'to' => [
                'string',
                'max:255',
                'nullable',
            ],
            'journey_distance' => [
                'numeric',
                'nullable',
            ],
            'journey_fare' => [
                'numeric',
                'nullable',
            ],
            'vehicle_type' => [
                'required',
                'in:' . implode(',', array_keys(VisitRoute::VEHICLE_TYPE_RADIO)),
            ],
            'journey_type' => [
                'nullable',
                'in:' . implode(',', array_keys(VisitRoute::JOURNEY_TYPE_RADIO)),
            ],
            'note' => [
                'string',
                'nullable',
            ],
            'route_cost' => [
                'numeric',
                'nullable',
            ],
            'user_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'reimbursement_id' => [
                'integer',
                'exists:visit_reimbursements,id',
                'nullable',
            ],
        ];
    }
}
