<?php

namespace App\Http\Requests;

use App\Models\SpecialPlannedDay;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateSpecialPlannedDayRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('special_planned_day_edit'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'title' => [
                'string',
                'required',
            ],
            'description' => [
                'string',
                'nullable',
            ],
            'leave_type' => [
                'required',
                'in:' . implode(',', array_keys(SpecialPlannedDay::LEAVE_TYPE_RADIO)),
            ],
            'from_date' => [
                'required',
                'date_format:' . config('project.date_format'),
            ],
            'to_date' => [
                'required',
                'date_format:' . config('project.date_format'),
            ],
        ];
    }
}
