<?php

namespace App\Http\Requests;

use App\Models\Purchase;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdatePurchaseRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('purchase_edit'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'suply_invc_no' => [
                'string',
                'min:15',
                'nullable',
            ],
            'prchs_date' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'party_ac' => [
                'nullable',
                'in:' . implode(',', array_keys(Purchase::PARTY_AC_SELECT)),
            ],
            'total_invoic' => [
                'numeric',
                'nullable',
            ],
            'csgt_amt' => [
                'numeric',
                'nullable',
            ],
            'sgst_amt' => [
                'numeric',
                'nullable',
            ],
            'igst_amt' => [
                'numeric',
                'nullable',
            ],
            'invoice_total_wo_tax' => [
                'numeric',
                'nullable',
            ],
            'details' => [
                'string',
                'min:20',
                'nullable',
            ],
        ];
    }
}
