<?php

namespace App\Http\Requests;

use App\Models\JobDesignation;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateJobDesignationRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('job_designation_edit'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'title' => [
                'string',
                'nullable',
            ],
            'description' => [
                'string',
                'nullable',
            ],
            'basic_salary' => [
                'numeric',
                'nullable',
            ],
            'basic_salary_max' => [
                'numeric',
                'nullable',
            ],
        ];
    }
}
