<?php

namespace App\Http\Requests;

use App\Models\Fy;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateFyRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('fy_edit'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'title' => [
                'string',
                'required',
                'unique:fies,title,' . request()->route('fy')->id,
            ],
            'alias_1' => [
                'string',
                'nullable',
            ],
            'from_date' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'to_date' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
        ];
    }
}
