<?php

namespace App\Http\Requests;

use App\Models\EmployeeInfo;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateEmployeeInfoRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('employee_info_edit'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'user_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'first_name' => [
                'string',
                'nullable',
            ],
            'middle_name' => [
                'string',
                'nullable',
            ],
            'last_name' => [
                'string',
                'nullable',
            ],
            'gender' => [
                'nullable',
                'in:' . implode(',', array_keys(EmployeeInfo::GENDER_RADIO)),
            ],
            'dob' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'citizenship' => [
                'string',
                'nullable',
            ],
            'age' => [
                'numeric',
                'nullable',
            ],
            'religion' => [
                'string',
                'nullable',
            ],
            'maritial_status' => [
                'nullable',
                'in:' . implode(',', array_keys(EmployeeInfo::MARITIAL_STATUS_SELECT)),
            ],
            'blood_group' => [
                'string',
                'nullable',
            ],
            'email' => [
                'email:rfc',
                'nullable',
            ],
            'present_address_line_1' => [
                'string',
                'nullable',
            ],
            'present_address_line_2' => [
                'string',
                'nullable',
            ],
            'present_address_line_3' => [
                'string',
                'nullable',
            ],
            'present_address_line_4' => [
                'string',
                'nullable',
            ],
            'present_address_district' => [
                'string',
                'nullable',
            ],
            'present_address_pin' => [
                'string',
                'nullable',
            ],
            'present_address_state' => [
                'string',
                'nullable',
            ],
            'present_address_landmark' => [
                'string',
                'nullable',
            ],
            'permanent_address_line_1' => [
                'string',
                'nullable',
            ],
            'permanent_address_line_2' => [
                'string',
                'nullable',
            ],
            'permanent_address_line_3' => [
                'string',
                'nullable',
            ],
            'permanent_address_line_4' => [
                'string',
                'nullable',
            ],
            'permanent_address_district' => [
                'string',
                'nullable',
            ],
            'permanent_address_pin' => [
                'string',
                'nullable',
            ],
            'permanent_address_state' => [
                'string',
                'nullable',
            ],
            'permanent_address_landmark' => [
                'string',
                'nullable',
            ],
            'personal_phone' => [
                'string',
                'nullable',
            ],
            'present_residence_phone' => [
                'string',
                'nullable',
            ],
            'permanent_residence_phone' => [
                'string',
                'nullable',
            ],
            'emergency_contact_1_name' => [
                'string',
                'nullable',
            ],
            'emergency_contact_1_relation' => [
                'string',
                'nullable',
            ],
            'emergency_contact_1_phone' => [
                'string',
                'nullable',
            ],
            'emergency_contact_2_name' => [
                'string',
                'nullable',
            ],
            'emergency_contact_2_relation' => [
                'string',
                'nullable',
            ],
            'emergency_contact_2_phone' => [
                'string',
                'nullable',
            ],
            'doj' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'department' => [
                'string',
                'nullable',
            ],
            'job_desgination_id' => [
                'integer',
                'exists:job_designations,id',
                'nullable',
            ],
            'esic' => [
                'string',
                'nullable',
            ],
            'uan' => [
                'string',
                'nullable',
            ],
            'aadhaar' => [
                'string',
                'nullable',
            ],
            'salary_ac_no' => [
                'string',
                'nullable',
            ],
            'salary_ac_bank' => [
                'string',
                'nullable',
            ],
            'salary_ac_ifsc' => [
                'string',
                'nullable',
            ],
            'pm_basic_salary' => [
                'numeric',
                'nullable',
            ],
            'pm_hra' => [
                'numeric',
                'nullable',
            ],
            'pm_pf' => [
                'numeric',
                'nullable',
            ],
            'pm_esic' => [
                'numeric',
                'nullable',
            ],
            'pm_ptax' => [
                'numeric',
                'nullable',
            ],
        ];
    }
}
