<?php

namespace App\Http\Requests;

use App\Models\EmployeeEducationalInfo;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateEmployeeEducationalInfoRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('employee_educational_info_edit'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'employee_info_id' => [
                'integer',
                'exists:employee_infos,id',
                'nullable',
            ],
            'degree_name' => [
                'string',
                'nullable',
            ],
            'year' => [
                'string',
                'nullable',
            ],
            'board_name' => [
                'string',
                'nullable',
            ],
            'subjects' => [
                'string',
                'max:500',
                'nullable',
            ],
            'grade' => [
                'string',
                'nullable',
            ],
            'course_type' => [
                'nullable',
                'in:' . implode(',', array_keys(EmployeeEducationalInfo::COURSE_TYPE_RADIO)),
            ],
        ];
    }
}
