<?php

namespace App\Http\Requests;

use App\Models\Company;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateCompanyRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('company_edit'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'name' => [
                'string',
                'max:50',
                'nullable',
            ],
            'mailing_name' => [
                'string',
                'max:30',
                'nullable',
            ],
            'address_line_one' => [
                'string',
                'max:50',
                'nullable',
            ],
            'address_line_two' => [
                'string',
                'nullable',
            ],
            'state' => [
                'string',
                'max:20',
                'nullable',
            ],
            'city' => [
                'string',
                'max:20',
                'nullable',
            ],
            'pin' => [
                'string',
                'max:20',
                'nullable',
            ],
            'phone' => [
                'string',
                'max:20',
                'nullable',
            ],
            'email' => [
                'string',
                'max:20',
                'nullable',
            ],
            'mobile' => [
                'string',
                'max:20',
                'nullable',
            ],
            'fax_no' => [
                'string',
                'max:20',
                'nullable',
            ],
            'website' => [
                'string',
                'max:30',
                'nullable',
            ],
            'gst_state' => [
                'string',
                'max:15',
                'nullable',
            ],
            'registration_type' => [
                'string',
                'max:15',
                'nullable',
            ],
            'gstin' => [
                'string',
                'max:30',
                'nullable',
            ],
            'period_gstr_one' => [
                'string',
                'nullable',
            ],
            'eway_bill_is_applicable' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'threshold_limit' => [
                'numeric',
                'nullable',
            ],
            'apply_for_inter_state' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'inter_threshold_limit' => [
                'numeric',
                'nullable',
            ],
        ];
    }
}
